#include <iostream>
#include <vector>
#include <utility>
#include <algorithm>
#include <map>
#include <string>
#include <unordered_map>
#include <unordered_set>

struct node
{
	int i;
	std::vector<node*> a;
};

bool recurse(int i, int d, std::vector<node>& g, std::vector<int>& r, std::vector<int>& v)
{
	if (i == 1 && v[i] && d == g.size())
	{
		r.push_back(1);
		return true;
	}
	if (v[i])
		return false;
	v[i] = 1;
	for (const auto* a : g[i].a)
	{
		bool rr = recurse(a->i, d + 1, g, r, v);
		if (rr)
		{
			r.push_back(i);
			return true;
		}
	}
	v[i] = 0;
	return false;
}

int main()
{
	int n, m;
	std::cin >> n >> m;
	std::vector<node> g(n + 1);
	for (int i = 0; i < m; i++)
	{
		int a, b;
		std::cin >> a >> b;
		g[a].a.push_back(&g[b]);
	}
	for (int i = 1; i < g.size(); i++)
	{
		auto& nn = g[i];
		nn.i = i;
		if (nn.a.empty())
		{
			std::cout << "NO" << std::endl;
			return 0;
		}
	}

	std::vector<int> r, v(n + 1, 0);
	if (!recurse(1, 1, g, r, v))
	{
		std::cout << "NO" << std::endl;
		return 0;
	}
	bool f = true;
	for (int i = 1; i < v.size(); i++)
		if (!v[i])
			f = false;
	if (!f)
	{
		std::cout << "NO" << std::endl;
		return 0;
	}
	std::cout << "YES" << std::endl;
	for (int i = r.size() - 1; i >= 0; i--)
		std::cout << r[i] << ' ';

}
